/* <nagg08.h>
 *
 * Copyright 2000 Numerical Algorithms Group
 *
 * Include file for NAG C Library g05 Chapter
 *
 * Mark 6, 2000.
 */

#ifndef NAGG08
#define NAGG08

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC

#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL g08aac(Integer n, const double x[], const double y[], Integer *s,
                     double * p, Integer * non_tied, NagError *fail);
  extern void g08aaf_f(const double x[], const double y[], Integer n, Integer *is,
                       Integer *n1, double *p, Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL g08acc(Integer n1, const double x[], Integer n2, const double y[], Integer *above,
                     Integer *below, double *p, NagError *fail);
  extern void g08acf_f(const double x[], Integer n, Integer n1, double w1[],
                       Integer *i1, Integer *i2, double *p, Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL g08aec(Integer k, Integer n, const double x[], Integer tdx, 
                     double *fr, double *p, NagError *fail);
  extern void g08aef_f(const double x[], Integer ix, Integer k, Integer n,
                       double w1[], double w2[], double *fr, double *p,
                       Integer *ifail);
  extern void g08aez_f(const double a[], double r[], Integer n, Integer ki,
                       double *xf);
  extern NAG_DLL_EXPIMP void NAG_CALL g08afc(Integer k, const Integer l[], const double x[], Integer lx, 
                     double *h, double *p, NagError *fail);
  extern void g08aff_f(const double x[], Integer lx, const Integer l[], Integer k,
                       double w1[], double *h, double *p, Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL g08agc(Integer n, const double x[], double xme, Nag_TailProbability tail,
                     Nag_IncSignZeros zeros, double *rs, double *rsnor, double *p,
                     Integer *nz1, NagError *fail);
  extern void g08agf_f(Integer n, const double x[], double xme, const char *tail,
                       const char *zeros, double *rs, double *rsnor, double *p,
                       Integer *nz1, double wrk[], Integer *ifail, Integer tail_len, Integer zeros_len);
  extern void g08agy_f(const double a[], double r[], Integer n, Integer ki,
                       double *xf);
  extern void g08agz_f(Integer n, const Integer ir[], Integer iv, double *p);
  extern void g08ahc(Integer n1, const double x[], Integer n2, const double y[],
                     Nag_TailProbability tail, double *u, double *unor,
                     double *p, Boolean *ties, double ranks[], NagError *fail);
  extern void g08ahf_f(Integer n1, const double x[], Integer n2, const double y[],
                       const char *tail, double *u, double *unor, double *p,
                       Boolean *ties, double ranks[], double wrk[], Integer *ifail,
                       Integer tail_len);
  extern void g08ajc(Integer n1, Integer n2, Nag_TailProbability tail, double u,
                     double *p, NagError *fail);
  extern void g08ajf_f(Integer n1, Integer n2, const char *tail, double u,
                       double *p, double wrk[], Integer lwrk, Integer *ifail,
                       Integer tail_len);
  extern void g08ajz_f(Integer n1, Integer n2, Integer iv, double *p,
                       double wrk[], Integer lwrk);
  extern void g08akc(Integer n1, Integer n2, Nag_TailProbability tail,
                     const double ranks[], double u, double *p, NagError *fail);
  extern void g08akf_f(Integer n1, Integer n2, const char *tail, const double ranks[],
                       double u, double *p, double wrk[], Integer lwrk,
                       Integer iwrk[], Integer *ifail, Integer tail_len);
  extern void g08akz_f(Integer n1, Integer n2, Integer iwrk[], Integer nsum,
                       Integer iv, double *p, double wrk[], Integer lwrk);
  extern void g08alf_f(Integer n, Integer k, const double x[], Integer ldx,
                       double *q, double *prob, Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL g08amc(Integer n1, const double x[], Integer n2, const double y[],
                     Nag_TailProbability tail, Nag_CompProb exact,
                     double *u, double *z, double *p, NagError *fail);
  extern void g08baf_f(const double x[], Integer n, Integer n1, double r[],
                       Integer itest, double *w, double *v, double *pw,
                       double *pv, Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL g08cbc(Integer n, const double x[], Nag_Distributions dist, double par[],
                     Nag_ParaEstimates estima, Nag_TestStatistics ntype, double *d,
                     double *z, double *p, NagError *fail);
  extern void g08cbf_f(Integer n, const double x[], const char *dist, double par[],
                       const char *estima, Integer ntype, double *d, double *z,
                       double *p, double sx[], Integer *ifail, Integer dist_len,
                       Integer estima_len);
  extern double g08cbz_f(Integer n, double d);
  extern double g08cbz_f(Integer n, double d);
  /// Max 10/13/04 CHANGE_G08CCF_F_FUNCTION_ARGUMENTS 
  //extern void g08ccf_f(Integer n, const double x[], 
                       //double (*cdf)(double ),
                       //Integer ntype, double *d, double *z, double *p,
                       //double sx[], Integer *ifail);
  typedef double (*PF_d_d)(double);
  extern void g08ccf_f(Integer n, const double x[], 
                       PF_d_d cdf,
                       Integer ntype, double *d, double *z, double *p,
                       double sx[], Integer *ifail);
  /// End CHANGE_G08CCF_F_FUNCTION_ARGUMENTS                     
  extern NAG_DLL_EXPIMP void NAG_CALL g08cdc(Integer n1, const double x[], Integer n2, const double y[],
                     Nag_TestStatistics ntype, double * d, double * z, double * p,
                     NagError *fail);
  extern void g08cdf_f(Integer n1, const double x[], Integer n2, const double y[],
                       Integer ntype, double *d, double *z, double *p,
                       double sx[], double sy[], Integer *ifail);
  extern double g08cdz_f(Integer n1, Integer n2, double d, Integer *ierror);
  extern NAG_DLL_EXPIMP void NAG_CALL g08cgc(Integer k2, const Integer ifreq[], const double cint[],
                     Nag_Distributions dist, const double par[], Integer iparam,
                     const double prob[], double * chisq, double * p, Integer * ndf,
                     double eval[], double chisqi[],   NagError *fail);
  extern void g08cgf_f(Integer k2, const Integer ifreq[], const double cint[], const char *dist,
                       const double par[], Integer iparam, const double prob[], double *chisq,
                       double *p, Integer *ndf, double eval[], double chisqi[],
                       Integer *ifail, Integer dist_len);
  extern double g08cgz_f(const char *cdist, double rint, const double par[], Integer *ifail,
                         Integer cdist_len);
  extern void g08daf_f(const double x[], Integer ix, Integer k, Integer n,
                       double rnk[], double *w, double *p, Integer *ifail);
  extern void g08daz_f(const double val[], Integer ix, Integer k, Integer n,
                       double rank[], double *t);
  extern NAG_DLL_EXPIMP void NAG_CALL g08eac(Integer n, const double x[], Integer maxr, Integer *nruns, 
                     double *chi, double *df,
                     double *prob, NagError *fail);
  extern void g08eaf_f(const char *cl, Integer n, const double x[], Integer m,
                       Integer maxr, Integer *nruns, Integer ncount[], double ex[],
                       double c[], Integer ldc, double *chi, double *df,
                       double *prob, double wrk[], Integer lwrk, Integer *ifail,
                       Integer cl_len);
  extern void g08eay_f(const char *upper, Integer n, const double a[], Integer lda,
                       const double x[], double *stat, double wk[], Integer *ierror,
                       Integer upper_len);
  extern void g08eaz_f(Integer ntot, Integer nr, double ex[], double c[],
                       Integer ldc, double wrk[], Integer lwrk, Integer *ierror);
  extern NAG_DLL_EXPIMP void NAG_CALL g08ebc(Integer n, const double x[], Integer msize,
                     Integer lag, double *chi, double *df, double *p, 
                     NagError *fail);
  extern void g08ebf_f(const char *cl, Integer n, const double x[], Integer msize,
                       Integer lag, Integer ncount[], Integer ldc, double *ex,
                       double *chi, double *df, double *p, double wrk[],
                       Integer *ifail, Integer cl_len);
  extern NAG_DLL_EXPIMP void NAG_CALL g08ecc(Integer n, const double x[], Integer msize, double *chi,
                     double *df, double *p, NagError *fail);
  extern void g08ecf_f(const char *cl, Integer n, const double x[], Integer msize,
                       Integer ncount[], Integer ldc, double *ex, double *chi,
                       double *df, double *p, Integer *ifail, Integer cl_len);
  extern NAG_DLL_EXPIMP void NAG_CALL g08edc(Integer n, const double x[], Integer m,
                     Integer k, double rl, double ru, double til,
                     double *chi,
                     double *df, double *prob, NagError *fail);
  extern void g08edf_f(const char *cl, Integer n, const double x[], Integer m,
                       Integer k, double rl, double ru, double til,
                       Integer *ngaps, Integer ncount[], double ex[], double *chi,
                       double *df, double *prob, Integer *ifail, Integer cl_len);
  extern NAG_DLL_EXPIMP void NAG_CALL g08rac(Nag_OrderType order, Integer ns, const Integer nv[], const double y[], Integer p, const double x[], Integer nx, Integer idist, Integer nmax, double tol, double parvar[], Integer npvar, Integer irank[], double zin[], double eta[], double vapvec[], double parest[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g08rbc(Nag_OrderType order, Integer ns, const Integer nv[], const double y[], Integer p, const double x[], Integer nx, const Integer icen[], double gamma, Integer nmax, double tol, double parvar[], Integer npvar, Integer irank[], double zin[], double eta[], double vapvec[], double parest[], NagError *fail); 

  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGG08 */
